#include "c4d_toolplugin.h"
#include "c4d_memory.h"
#include "c4d_basecontainer.h"
#include "c4d_basebitmap.h"
#include "c4d_file.h"
#include "c4d_general.h"
#include "c4d_gui.h"

Bool ToolData::InitTool(BaseDocument *doc, BaseContainer &data, BaseThread *bt)
{
	return TRUE;
}

void ToolData::FreeTool(BaseDocument *doc, BaseContainer &data)
{
}

Bool ToolData::MouseInput(BaseDocument *doc, BaseContainer &data, BaseDraw *bd, EditorWindow *win, const BaseContainer &msg)
{
	return TRUE;
}

LONG ToolData::GetState(BaseDocument *doc)
{
	return CMD_ENABLED;
}

Bool ToolData::GetCursorInfo(BaseDocument *doc, BaseContainer &data, BaseDraw *bd, Real x,Real y, BaseContainer &bc)
{
	return FALSE;
}

LONG ToolData::Draw(BaseDocument *doc, BaseContainer &data, BaseDraw *bd, BaseDrawHelp *bh, BaseThread *bt,LONG flags)
{
	return DRAW_AXIS;
}

CDialog* ToolData::AllocDialog(BaseContainer *bc, CDialog *cd_parent, LONG dlg_id)
{
  if (!cd_parent) return NULL;
  SubDialog* dlg = AllocSubDialog(bc);
  if (!dlg) return NULL;
  C4DOS.Cd->AttachSubDialog(cd_parent, dlg_id, dlg->Get());
  return dlg->Get();
}

void ToolData::FreeDialog(CDialog *cd)
{
  SubDialog *dlg = (SubDialog*)C4DOS.Cd->GetUserData(cd);
	gDelete(dlg);
}

Bool ToolData::InitDisplayControl(BaseDocument *doc, BaseContainer &data, BaseDraw *bd, AtomArray *active)
{
	return FALSE;
}

void ToolData::FreeDisplayControl(void)
{
}

Bool ToolData::DisplayControl(BaseDocument *doc, BaseObject *op, BaseObject *chainstart, BaseDraw *bd, BaseDrawHelp *bh, ControlDisplayStruct &cds)
{
	return TRUE;
}

SubDialog* ToolData::AllocSubDialog(BaseContainer* bc)
{
	return NULL;
}

Bool RegisterToolPlugin(LONG id, const String &str, LONG info, String iconname, const String &help, ToolData *dat)
{
	if (!dat) return FALSE;

	Bool ok=FALSE;

	AutoAlloc<BaseBitmap> icon;

	if (icon && icon->Init(GeGetPluginPath()+String("res")+iconname)==IMAGE_OK)
		ok=RegisterToolPlugin(id,str,info,icon,help,dat);

	return ok;
}

Bool RegisterToolPlugin(LONG id, const String &str, LONG info, const String &help, ToolData *dat)
{
	return RegisterToolPlugin(id,str,info,NULL,help,dat);
}

Bool RegisterToolPlugin(LONG id, const String &str, LONG info, BaseBitmap *icon, const String &help, ToolData *dat)
{
	if (!dat) return FALSE;

	TOOLPLUGIN np;
	ClearMem(&np,sizeof(np));

	np.adr								= dat;
	np.help								= (String*)&help;
	np.command_icon				= icon;
	np.info								= info;
												 
	np.Destructor					= &ToolData::Destructor;
	np.MouseInput					= &ToolData::MouseInput;
	np.GetState						= &ToolData::GetState;
	np.GetCursorInfo			= &ToolData::GetCursorInfo;
	np.Draw								= &ToolData::Draw;
	np.AllocDialog				= &ToolData::AllocDialog;
	np.FreeDialog					= &ToolData::FreeDialog;
	np.InitTool						= &ToolData::InitTool;
	np.FreeTool						= &ToolData::FreeTool;
	np.InitDisplayControl = &ToolData::InitDisplayControl;
	np.FreeDisplayControl = &ToolData::FreeDisplayControl;
	np.DisplayControl			= &ToolData::DisplayControl;

	return GeRegisterPlugin(C4DPL_TOOL,id,str,&np,sizeof(np));
}

void EditorWindow::DrawXORLine(LONG x1,LONG y1,LONG x2,LONG y2)
{
	C4DOS.Ge->EwDrawXORLine(this,x1,y1,x2,y2);
}

void EditorWindow::MouseDragStart(LONG button,Real mx,Real my,LONG flag)
{
	C4DOS.Ge->EwMouseDragStart(this,button,mx,my,flag);
}

LONG EditorWindow::MouseDrag(Real *mx,Real *my,BaseContainer *channels)
{
	return C4DOS.Ge->EwMouseDrag(this,mx,my,channels);
}

LONG EditorWindow::MouseDragEnd(void)
{
	return C4DOS.Ge->EwMouseDragEnd(this);
}

Bool EditorWindow::BfGetInputState(LONG askdevice,LONG askchannel,BaseContainer *res)
{	
	return C4DOS.Ge->EwBfGetInputState(this,askdevice,askchannel,res);
}

Bool EditorWindow::BfGetInputEvent(LONG askdevice,BaseContainer *res)
{
	return C4DOS.Ge->EwBfGetInputEvent(this,askdevice,res);
}

void EditorWindow::StatusSetText(const String &str)
{ 
	C4DOS.Ge->StatusSetText(&str); 
}
